<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Accessory extends Model 
{

    protected $table = 'accessories';
    public $timestamps = true;
    protected $fillable = array('id', 'accessories_store_id', 'name_en', 'name_ar', 'description_en', 'description_ar', 'category_id', 'sub_category_id', 'brand_id', 'car_model_id', 'guarantee', 'guarantee_year', 'guarantee_month', 'price', 'discount_type', 'discount', 'number_of_views', 'available', 'active');

    public function accessoriesStore()
    {
        return $this->belongsTo('App\Models\AccessoriesStore');
    }

    public function files()
    {
        return $this->morphMany('App\Models\File');
    }

    public function accessoryStorePurchases()
    {
        return $this->belongsToMany('AccessoryStorePurchase', 'accessory_store_purchase_accessories');
    }

    public function category()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function SubCategory()
    {
        return $this->belongsTo('App\Models\SubCategory');
    }

    public function offers()
    {
        return $this->morphMany('App\Models\Offer', 'offerable');
    }

}